# C.O.R.E. v0.6 verified

country = { 
	tag = ENG
	capital = 499
	alignment =  { x= 100 y = 0 } 
	ai = "core_UK.ai"
	manpower = 1450
	diplomats = 15
	transports = 100
	# Resource Reserves
	coal = 20000  steel = 20000 rubber = 20000 oil = 10000 supplies = 20000

	diplomacy = {
	#access through the empire
	relation = { tag = SAF access = yes }
	relation = { tag = CAN access = yes }
	relation = { tag = AST access = yes }
	relation = { tag = NZL access = yes }
	relation = { tag = OMN access = yes }
	relation = { tag = YEM access = yes }
	relation = { tag = IRQ access = yes }
	relation = { tag = BHU access = yes }
	relation = { tag = NEP access = yes }
	relation = { tag = EGY access = yes }
			}

	techlevels = { 12000 12100 13000 13100 11000 11100 14000 1000 1100 1200 1300 
		2000 2100 # Inter War Tanks
		5000 5100 5200 9000 9100 10000 10100 7000 7100 8000 8100 8200 
		3000 3100  4000 4100 4200 4300 
		#MateDow Naval Mod Additions
		6000 6100 6200 6300 6400 6500
	 }
	 techapps = { 12001  13001  13002  13004  11001  11002  11004 14001  14003  14005 14008 14012
		1001  1107  1201 1205  1301  2001  2002  2003 2004  2005 2006 
		2201 # Basic Tank Gear
		2203 # Basic Tank Engine
		2202 # Basic Tank Suspension
		2101 # Basic Optical Sights
		2986 # Tankette Prototype
		2987 # .30 cal Tankette
		2985 # Multiturreted Tank Prototype
		2989 # Multi turreted Tank (20mm)
		2103 2104 5101 9001 10002 10003 7001 7002 7101 7102 3002 3003 3004 3005 3006 3007
		3101 3102 4001 4101 4102 4201 4202 4203 4204 12004 12101 13003 13006 1203 5202 
		9002 9005 4301 4302 4303 3001 5001 5002 5003 5004 1975 # .30 cal Maxim HMG
		#MateDow Naval Mod Additions
		6013 6014 6015 6016  6017 6018 6019 6020 6021 6022 6023 6024 6025 6026 6027 6028 6029 6030
		6031 6032 6033 6034 6035 6036 6037 6038 6039 6040 6041 6113 6114 6115 6116 6117 6118 
		6207 6208 6209 6210 6211 6307 6308 6309 6310 6311 6411 6412 6413 6414 6415 6416 6514 6515
		6516 6517 6518 6519 6521 6522 6523 6524 6529 6530 6531 6532 6533 6610 6611 6612 6613 6614
		6616 6618 
		14250 14251 14252 14253  14254 14255 14256 14257
	 }


	ownedprovinces = { 482 483 484 485 486 487 488 489 490 491 493  497 498 499 500 501 502 503
	#India
	1450 1442 1443 1444 1445 1446 1497 1447 1456 1457 1451 1458 1459 1463 1464 1460 1496 1469 
	1467 1468 1466 1465 1478 1479 1480 1498 1490 1592 1584 1585 1586 1491 1499 1495  
	1417 1418 1448 1434 1435 1449 
	#Egypt
	1205 1275  1209 1283 1348  1091 1090 1102
	#removed because of the insertion of Egypt
	#1093 1099 1100 1101 1103 1104 1200 1201 1202 1203 1206  
	#Sudan
	1193 1196 1199 1198 1195 1298 1190 1191 
	#Indochina etc
	1788 1787 1766 1765 1762 1717 1590 1589 1593 1594 1587 1588 1599 1789 
	#Carribean
	308 309 276 275 274 272 270 268 260 225 233 222 461 
	#Misc British
	414 469 1310 1278 989 896 40 50 56 2129 2119 2121 168 
	# British India
	1500 1439 1501 1582 1745 1438 1752 1580 1583 2200 1953 
	# British East Africa (1301 removed to Italy)
	1308 1307 1304 1311 1309 1306 1183 1287 1340 1332 1331 37 38 
	#British South Africa
	1166 1163 1180 1181 1146 1145  1144 
	#British West Africa
	1063 1065 1070 1066 1069 1067 1057 1054 1042 1035 1068 1147 
	}
	
	controlledprovinces = {
	482 483 484 485 486 487 488 489 490 491 493 497 498 499 500 501 502 503
	#India
	1450 1442 1443 1444 1445 1446 1497 1447 1456 1457 1451 1458 1459 1463 1464 1460 1496 1469 1467 1468
	1466 1465 1478 1479 1480 1498 1490 1592 1584 1585 1586 1491 1499 1495 1417 1418 1448 1434 1435 1449 
	#Egypt
	1205 1275 1209 1283 1348 1091 1093 1099 1090 1100 1101 1102 1103 1104 1200 1201 1202 1203 1206  
	#Sudan
	1193 1196 1199 1198 1195 1298 1190 1191 
	#Indochina etc
	1788 1787 1766 1765 1762 1717 1590 1589 1593 1594 1587 1588 1599 1789 
	#Carribean
	308 309 276 275 274 272 270 268 260 225 233 222 461 
	#Misc British
	414 469 1310 1278 989 896 40 50 56 2129 2119 2121 168 
	# British India
	1500 1439 1501 1582 1745 1438 1752 1580 1583 2200 1953
	# British East Africa (1301 removed to Italy)
	1308 1307 1304 1311 1309 1306 1183 1287 1340 1332 1331 37 38
	#British South Africa
	1166 1163 1180 1181 1146 1145  1144 
	#British West Africa
	1063 1065 1070 1066 1069 1067 1057 1054 1042 1035 1068 1147 
	}
	
	nationalprovinces =   {
	482 483 484 485 486 487 488 489 490 491 493 497 498 499 500 501 502 503
	#India - "The Jewel in the Crown" is National. UK should get full yield from IC there.
	1450 1442 1443 1444 1445 1446 1497 1447 1456 1457 1451 1458 1459 1463 1464 1460 1496 1469 1467 1468 1466 
	1465 1478 1479 1480 1498 1490 1592 1584 1585 1586 1491 1499 1495 1417 1418 1448 1434 1435 1449 1587 1588 
	1590 1589 1593 1594 1599 1745 
	# British India 1953 removed
	1500 1439 1501 1582 1438 1752 1580 1583 2200 
	#Indochina etc
	# 1788 1787 1766 1765 1762 1717 1789 
	#Egypt
	# 1205 1275 1209 1283 1348 1091 1093 1099 1090 1100 1101 1102 1103 1104 1200 1201 1202 1203 1206  
	#Sudan
	# 1193 1196 1199 1198 1195 1298 1190 1191 
	#Carribean
	#308 309 276 275 274 272 270 268 260 225 233 222 461 
	#Misc British
	168 414 469 989
	#1310 1278 896 40 50 56 2129 2119 2121 
	# British East Africa
	# 1301 1308 1307 1304 1311 1309 1306 1183 1287 1340 1332 1331 37 38  
	#British South Africa
	#1166 1163 1180 1181 1146 1145  1144 
	#British West Africa
	#1063 1065 1070 1066 1069 1067 1057 1054 1042 1035 1068 1147 
	}

    convoy = { 
        id = { type = 14712 id = 3314 } 
	# Lagos to Manchester w/ rubber
        transports = 20 
        escorts = 0 
	rubber = yes 
	coal = no 
	steel = no 
	oil = no 
	supplies = no 
        path = { 1063 1062 1055 463 464 455 453 1014 962 473 505 515 489 } 
        } 
    convoy = { 
        id = { type = 14712 id = 3316 } 
	# Plymouth to Bombay w/ supplies, oil
        transports = 25 
        escorts = 0 
	rubber = no 
	coal = no 
	steel = no 
	oil = yes 
	supplies = yes 
        path = { 501 920 473 962 1014 453 455 464 460 470 1152 1161 1326 1325 1328 1474 1473 1472 1470 1459 } 
	} 
    convoy = { 
        id = { type = 14712 id = 3318 } 
	# Plymouth to Gibraltar w/ oil, supplies
        transports = 8 
        escorts = 0 
	rubber = no 
	coal = no 
	steel = no 
	oil = yes 
	supplies = yes 
        path = { 501 920 473 962 1014 1010 989 } 
	} 
    convoy = { 
        id = { type = 14712 id = 3321 } 
	# Belize to Glasgow w/ rubber
        transports = 12  
        escorts = 0 
	rubber = yes 
	coal = no 
	steel = no 
	oil = no 
	supplies = no 
        path = { 233 236 234 227 224 427 428 448 474 514 486 } 
        } 
    convoy = { 
        id = { type = 14712 id = 3324 } 
	# Port of Spain to Glasgow w/ oil
        transports = 13 
        escorts = 0 
	rubber = no 
	coal = no 
	steel = no 
	oil = yes 
	supplies = no 
        path = { 276 314 423 454 450 447 474 514 486 } 
        } 
    convoy = { 
        id = { type = 14712 id = 3327 } 
	# Bombay to Colombo w/ oil, supplies
        transports = 7  
        escorts = 0 
	rubber = no
	coal = no 
	steel = no
	oil = yes 
	supplies = yes 
        path = { 1459 1470 1482 1481 1485 1480 } 
        } 
    convoy = { 
        id = { type = 14712 id = 3317 } 
	# Bombay to Singapore w/ oil, supplies
        transports = 10 
        escorts = 0 
	rubber = no
	coal = no 
	steel = no 
	oil = yes 
	supplies = yes 
        path = { 1459 1470 1482 1483 1476 1754 1761 1769 1766 } 
        } 
    convoy = { 
        id = { type = 14712 id = 2798 } 
	# Southampton to Port Said w/ supplies, oil (I kept this one because UK is counting on egypt to support troops)
        transports = 20 
        escorts = 0 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 502 516 517 920 473 962 1014 1010 994 1008 1002 1001 943 940 899 895 888 886 1090 } 
        } 
    convoy = { 
        id = { type = 14712 id = 2800 } 
	# Singapore to Hong Kong w/ Oil, Supplies
        transports = 8 
        escorts = 0 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 1766 1770 1763 1798 1725 1723 1717 } 
        } 
    convoy = { 		  
        id = { type = 14712 id = 2804 } 
	# Gibraltar to Valetta(malta?) w/ oil, supplies
        transports = 9 
        escorts = 0 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 989 1008 1002 999 942 940 899 896 } 
        } 
    convoy = { 
        id = { type = 14712 id = 2806 } 
	# Plymouth to Bermuda Islands w/ oil, Supplies
        transports = 9 
        escorts = 0 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 501 920 473 447 428 427 223 222 } 
        } 
    convoy = { 
        id = { type = 14712 id = 2808 } 
	# Kuwait to Plymouth w/ coal, steel, oil
        transports = 23 
        escorts = 0 
        rubber = no 
        coal = yes 
        steel = yes 
        oil = yes 
        supplies = no 
        path = { 1278 1351 1416 1415 1472 1473 1474 1328 1325 1326 1161 1152 470 460 2151 455 453 1014 962 473 505 501 } 
        } 
    convoy = { 
        id = { type = 14712 id = 2811 } 
	# Abu Dhabi to Plymouth w/ coal, steel, oil
        transports = 22 
        escorts = 0 
        rubber = no 
        coal = yes 
        steel = yes 
        oil = yes 
        supplies = no 
        path = { 1348 1416 1415 1472 1473 1474 1328 1325 1326 1161 1152 470 460 2151 455 453 1014 962 473 505 501 } 
        } 
    convoy = { 
        id = { type = 14712 id = 2813 } 
	# Singapore to Cardiff w/ Rubber
        transports = 80 
        escorts = 0 
        rubber = yes 
        coal = no 
        steel = no 
        oil = no 
        supplies = no 
        path = { 1766 1769 1761 1754 1476 1475 1327 1326 1161 1152 470 460 2151 455 453 1014 962 473 505 491 } 
        } 
   convoy = { 
        id = { type = 14712 id = 2817 } 
	# Bombay to Cardiff w/ coal, steel, rubber
        transports = 88 
        escorts = 0 
        rubber = yes 
        coal = yes 
        steel = yes 
        oil = no 
        supplies = no 
        path = { 1459 1452 1472 1473 1474 1328 1325 1326 1161 1152 470 460 2151 455 453 1014 962 473 505 491 } 
        }
   convoy = { 
        id = { type = 14712 id = 2829 } 
	# Freetown to Cardiff w/ steel, rubber
        transports = 16 
        escorts = 0 
        rubber = yes 
        coal = no 
        steel = yes 
        oil = no 
        supplies = no 
        path = { 1042 1038 1037 458 453 1014 962 473 505 491 } 
        }
   convoy = { 
        id = { type = 14712 id = 2831 } 
	# Cardiff to Freetown w/ oil, supplies
        transports = 11 
        escorts = 0 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 491 505 473 962 1014 453 458 1037 1038 1042 } 
        }
   convoy = { 
        id = { type = 14712 id = 4083 } 
	# Mombasa to Cardiff w/ rubber
        transports = 30 
        escorts = 0 
        rubber = yes 
        coal = no 
        steel = no 
        oil = no 
        supplies = no 
        path = { 1306 1313 1333 1321 1320 1325 1326 1161 1152 470 460 464 455 453 1014 962 473 505 491 } 
        }
   convoy = { 
        id = { type = 14712 id = 4231 } 
	# Aden to Cardiff w/ coal, steel
        transports = 21 
        escorts = 0 
        rubber = no 
        coal = yes 
        steel = yes 
        oil = no 
        supplies = no 
        path = { 1283 1343 1345 1473 1474 1328 1325 1326 1161 1152 470 460 464 455 453 1014 962 473 505 491 } 
        } 
    convoy = { 
        id = { type = 14712 id = 4477 } 
	# Bandar Seri Begawan to Cardiff w/ rubber, oil
        transports = 44 
        escorts = 0 
        rubber = yes 
        coal = yes 
        steel = yes 
        oil = yes 
        supplies = no 
        path = { 1788 1795 1764 1781 1776 1777 1476 1475 1327 1326 1161 1152 470 460 2151 455 453 1014 962 473 505 491 } 
        } 
    convoy = { 
        id = { type = 14712 id = 4584 } 
	# Bombay to Suez w/ oil Supplies
        transports = 12 
        escorts = 0 
        rubber = no 
        coal = no 
        steel = no 
        oil = yes 
        supplies = yes 
        path = { 1459 1452 1472 1344 1343 1291 1292 1286 1204 1207 1102 } 
        }
    convoy = { 
        id = { type = 14712 id = 4588 } 
	# Valetta to Sidi Barrani w/ oil, supplies
        transports = 5 
        escorts = 0 
        rubber = yes 
        coal = yes 
        steel = yes 
        oil = yes 
        supplies = no 
        path = { 896 895 888 1091 } 
        } 

   convoy = { 
        id = { type = 14713 id = 2421 } 
	# Manchester to Halifax(CAN) w/ rubber, coal
        transports = 37 
        escorts = 0 
        rubber = yes 
        coal = yes 
        steel = no 
        oil = no 
        supplies = no 
        path = { 489 515 514 474 448 429 171 157 153 } 
        } 
    convoy = { 
        id = { type = 14713 id = 2425 } 
	# manchester to Cape Town w/ rubber, oil
        transports = 21 
        escorts = 0 
        rubber = yes 
        coal = no 
        steel = no 
        oil = yes 
        supplies = no 
        path = { 489 515 505 473 962 1014 453 455 464 460 467 1152 1161 1160 1156 } 
        } 
    convoy = { 
        id = { type = 14713 id = 2443 } 
	# Colombo to Melbourne w/ Rubber
        transports = 40 
        escorts = 0 
        rubber = yes 
        coal = no 
        steel = no 
        oil = no 
        supplies = no 
        path = { 1480 1485 1484 1476 1949 2056 2082 2084 2075 } 
        } 


#############
# OOB
#############

	landunit = {
		name = "Aldershot Command"
		location = 500
		id = { type = 10499 id = 1 }
		division = { id = { type = 10499 id = 2 } name = "1st Infantry Division" 
	type = infantry strength = 70 }
		division = { id = { type = 10499 id = 3 } name = "2nd Infantry Division" 
	type = infantry strength = 70 }

	}

	landunit = {
		name = "Northern Command"
		location = 490
		id = { type = 10499 id = 4 }
		division = { id = { type = 10499 id = 5 } name = "5th Infantry Division" 
	type = infantry strength = 60 }
	}



	landunit = {
		name = "Southern Command"
		location = 503
		id = { type = 10499 id = 6 }
		division = { id = { type = 10499 id = 7 } name = "3rd Infantry Division" 
	type = infantry strength = 60 }
	}


	landunit = {
		name = "Hong Kong Command"
		location = 1717
		id = { type = 10499 id = 8 }
		division = { id = { type = 10499 id = 9 } name = "Hong Kong Defense Force" 
	type = infantry strength = 10 }
	}


	landunit = {
		name = "Singapore Command"
		location = 1766
		id = { type = 10499 id = 10 }
		division = { id = { type = 10499 id = 11 } name = "Singapore Defence Force" type = infantry strength = 25 }
	}


	landunit = {
		name = "Gibraltar Command"
		location = 989
		id = { type = 10499 id = 12 }
		division = { id = { type = 10499 id = 13 } name = "Gibraltar Defense Force" type = infantry strength = 20 }
	}
	landunit = {
		name = "Ceylon Command"
		location = 1480
		id = { type = 10499 id = 14 }
		division = { id = { type = 10499 id = 15 } name = "Ceylon Defense Force" 
	type = infantry strength = 15 }
	}

	landunit = {
		name = "Malta Command"
		location = 896
		id = { type = 10499 id = 16 }
		division = { id = { type = 10499 id = 17 } name = "Malta Defense Force" 
	type = infantry strength = 20 }
	}

	landunit = {
		name = "Middle East Command"
		location = 1101
		id = { type = 10499 id = 18 }
		division = { id = { type = 10499 id = 19 } name = "7th Infantry Division" 
		type = infantry strength = 60 }
		division = { id = { type = 10499 id = 20 } name = "8th Infantry Division" 
		type = infantry strength = 40 }
	}


	landunit = {
		name = "1st Indian Infantry"
		location = 1446
		id = { type = 10499 id = 24 }
		division = { id = { type = 10499 id = 25 } name = "1st Indian Infantry" 
		type = infantry strength = 50 }
	}


	landunit = {
		name = "2nd Indian Infantry"
		location = 1447
		id = { type = 10499 id = 26 }
		division = { id = { type = 10499 id = 27 } name = "2nd Indian Infantry" 
		type = infantry strength = 40 }
	}


	landunit = {
		name = "3rd Indian Infantry"
		location = 1435
		id = { type = 10499 id = 28 }
		division = { id = { type = 10499 id = 29 } name = "3rd Indian Infantry" 
		type = infantry strength = 40 }
	}


	landunit = {
		name = "4th Indian Infantry"
		location = 1449
		id = { type = 10499 id = 30 }
		division = { id = { type = 10499 id = 31 } name = "4th Indian Infantry" 
		type = infantry strength = 40 }
	}


	landunit = {
		name = "5th Indian Infantry"
		location = 1434
		id = { type = 10499 id = 32 }
		division = { id = { type = 10499 id = 33 } name = "5th Indian Infantry" 
		type = infantry strength = 40 }
	}


	landunit = {
		name = "6th Indian Infantry"
		location = 1490
		id = { type = 10499 id = 34 }
		division = { id = { type = 10499 id = 35 } name = "6th Indian Infantry" 
		type = infantry strength = 45 }
	}



	landunit = {
		name = "7th Indian Infantry"
		location = 1495
		id = { type = 10499 id = 124 }
		division = { id = { type = 10499 id = 125 } name = "7th Indian Infantry" 
		type = infantry strength = 50 }
	}



	landunit = {
		name = "8th Indian Infantry"
		location = 1585
		id = { type = 10499 id = 126 }
		division = { id = { type = 10499 id = 127 } name = "8th Indian Infantry" 
		type = infantry strength = 40 }
	}


	landunit = {
		name = "9th Indian Infantry"
		location = 1450
		id = { type = 10499 id = 128 }
		division = { id = { type = 10499 id = 129 } name = "9th Indian Infantry" 
		type = infantry strength = 50 }
	}


	landunit = {
		name = "10th Indian Infantry"
		location = 1459
		id = { type = 10499 id = 130 }
		division = { id = { type = 10499 id = 131 } name = "10th Indian Infantry" 
		type = infantry strength = 40 }
	}


	landunit = {
		name = "11th Indian Infantry"
		location = 1466
		id = { type = 10499 id = 135 }
		division = { id = { type = 10499 id = 133 } name = "11th Indian Infantry" 
		type = infantry strength = 30 }
	}


	landunit = {
		name = "12th Indian Infantry"
		location = 1448
		id = { type = 10499 id = 132 }
		
		division = { 
			id = { type = 10499 id = 134 } 
			name = "12th Indian Infantry" 
			type = infantry strength = 40
					}
	}
	landunit = {
		name = "1st Sudanese Colonials"
		location = 1198
		id = { type = 10499 id = 136 }
		
		division = { 
			id = { type = 10499 id = 137 } 
			name = "1st Sudanese Colonials" 
			type = militia 
			strength = 40
					}
	}
	landunit = {
		name = "2nd Sudanese Colonials"
		location = 1198
		id = { type = 10499 id = 138 }
		
		division = { 
			id = { type = 10499 id = 139 } 
			name = "2nd Sudanese Colonials" 
			type = militia 
			strength = 40
					}
	}
	landunit = {
		name = "3rd Sudanese Colonials"
		location = 1198
		id = { type = 10499 id = 140 }
		
		division = { 
			id = { type = 10499 id = 141 } 
			name = "3rd Sudanese Colonials" 
			type = militia 
			strength = 40
					}
	}
	landunit = {
		name = "1st Ugandian Colonials"
		location = 1304
		id = { type = 10499 id = 142 }
		
		division = { 
			id = { type = 10499 id = 143 } 
			name = "1st Ugandian Colonials" 
			type = militia 
			strength = 40
					}
	}
	landunit = {
		name = "2nd Ugandian Colonials"
		location = 1307
		id = { type = 10499 id = 144 }
		
		division = { 
			id = { type = 10499 id = 145 } 
			name = "2nd Ugandian Colonials" 
			type = militia 
			strength = 40
					}
	}
	landunit = {
		name = "1st Kenyan Colonials"
		location = 1306
		id = { type = 10499 id = 146 }
		
		division = { 
			id = { type = 10499 id = 147 } 
			name = "1st Kenyan Colonialss" 
			type = militia 
			strength = 40
					}
	}
	landunit = {
		name = "2nd Kenyan Colonials"
		location = 1308
		id = { type = 10499 id = 148 }
		
		division = { 
			id = { type = 10499 id = 149 } 
			name = "2nd Kenyan Colonials" 
			type = militia 
			strength = 40
					}
	}
	landunit = {
		name = "1st Tanzanian Colonials"
		location = 1309
		id = { type = 10499 id = 150 }
		
		division = { 
			id = { type = 10499 id = 151 } 
			name = "1st Tanzanian Colonials" 
			type = militia 
			strength = 40
					}
	}
	landunit = {
		name = "2nd Tanzanian Colonials"
		location = 1311
		id = { type = 10499 id = 152 }
		
		division = { 
			id = { type = 10499 id = 153 } 
			name = "2nd Tanzanian Colonials" 
			type = militia 
			strength = 40
					}
	}

	airunit =
	{
		location = 499
        id = { type = 13016 id = 170 }
		name = "No.1 Group"

		division =
		{
	        id = { type = 13016 id = 171 }
			name = "No.1 Group"
			type = tactical_bomber
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 500
        id = { type = 13016 id = 172 }
		name = "No.2 Group"

		division =
		{
	        id = { type = 13016 id = 173 }
			name = "No.2 Group"
			type = strategic_bomber
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 498
        id = { type = 13016 id = 174 }
		name = "No.3 Group"

		division =
		{
	        id = { type = 13016 id = 175 }
			name = "No.3 Group"
			type = strategic_bomber
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 490
        id = { type = 13016 id = 176 }
		name = "No.4 Group"

		division =
		{
	        id = { type = 13016 id = 177 }
			name = "No.4 Group"
			type = strategic_bomber
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 498
        id = { type = 13016 id = 178 }
		name = "No.5 Group"

		division =
		{
	        id = { type = 13016 id = 179 }
			name = "No.5 Group"
			type = tactical_bomber
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 497
        id = { type = 13016 id = 180 }
		name = "No.11 Group"

		division =
		{
	        id = { type = 13016 id = 181 }
			name = "No.11 Group"
			type = fighter
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 488
        id = { type = 13016 id = 182 }
		name = "No.12 Group"

		division =
		{
	        id = { type = 13016 id = 183 }
			name = "No.12 Group"
			type = fighter
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 490
        id = { type = 13016 id = 184 }
		name = "No.13 Group"

		division =
		{
	        id = { type = 13016 id = 185 }
			name = "No.13 Group"
			type = fighter
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 1101
        id = { type = 13016 id = 186 }
		name = "Middle East Air Command"

		division =
		{
	        id = { type = 13016 id = 187 }
			name = "Middle East Group"
			type = tactical_bomber
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 1585
        id = { type = 13016 id = 188 }
		name = "India Air Command"

		division =
		{
	        id = { type = 13016 id = 189 }
			name = "Indian Group"
			type = tactical_bomber
			model = 0
			strength = 70
		}
	}
	airunit =
	{
		location = 1766
        id = { type = 13016 id = 190 }
		name = "Far East Air Command"

		division =
		{
	        id = { type = 13016 id = 191 }
			name = "Far East Group"
			type = tactical_bomber
			model = 0
			strength = 70
		}
	}




##############################################
# Royal Navy OOB
# CORE Version 0.6
# by MateDow
##############################################

navalunit = {
	name = "Home Fleet"
	id = { type = 13016 id = 200 }
	location = 482 #Scapa Flow
	leader = 1015 #Backhouse

	division = { id = { type = 13016 id = 201 } name = "HMS Nelson" type = battleship model = 5 maxspeed = 23 }
	division = { id = { type = 13016 id = 202 } name = "HMS Rodney" type = battleship model = 5 maxspeed = 23 }
	division = { id = { type = 13016 id = 203 } name = "HMS Royal Sovereign" type = battleship model = 3 }
	division = { id = { type = 13016 id = 204 } name = "HMS Royal Oak" type = battleship model = 3 }
	division = { id = { type = 13016 id = 205 } name = "HMS Resolution" type = battleship model = 3 }
	division = { id = { type = 13016 id = 206 } name = "HMS Ramillies" type =  battleship model = 3 }
	division = { id = { type = 13016 id = 207 } name = "HMS Hood" type = battleship model = 4 } 
	division = { id = { type = 13016 id = 208 } name = "HMS Renown" type = battleship model = 4 } 
	division = { id = { type = 13016 id = 209 } name = "HMS Furious" type = carrier model = 6 }
	airunit = { id = { type = 13016 id = 1000 } name = "HMS Furious Air Wing (TB)"
		division = { id = { type = 13016 id = 1001 } name = "Furious Air Wing (TB)" strength = 100 type = torpedo_plane model = 0 }
		}
	division = { id = { type = 13016 id = 210 } name = "HMS Cairo" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 211 } name = "HMS Galatea" type = cruiser model = 4 }
	division = { id = { type = 13016 id = 213 } name = "HMS Neptune" type = cruiser model = 4 }
	division = { id = { type = 13016 id = 214 } name = "HMS Orion" type = cruiser model = 4 }
	division = { id = { type = 13016 id = 215 } name = "6th Destroyer Flotilla" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 216 } name = "8th Destroyer Flotilla (A)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 217 } name = "8th Destroyer Flotilla (B)" type = destroyer model = 4 }
}
	navalunit = {
		id = { type = 13016 id = 500 }
		name = "HMS Argus"
		location = 482
		division = {
			id = { type = 13016 id = 501 }
			name = "HMS Argus"
			type = carrier
			model = 0 
		}
	}




navalunit = {
	name = "3rd Submarine Flotilla"
	id = { type = 13016 id = 218 }
	location = 482 #Scapa Flow
	division = { id = { type = 13016 id = 219 } name = "3rd Submarine Flotilla" type = submarine model = 1 }
	}



navalunit = {
	name = "1st Transport Flotilla"
	id = { type = 13016 id = 220 }
	location = 482 #Scapa Flow
	division = { id = { type = 13016 id = 221 } name = "1st Transport Flotilla (A)" type = transport model = 1 }
	division = { id = { type = 13016 id = 222 } name = "1st Transport Flotilla (B)" type = transport model = 1 }
	}



navalunit = {
	name = "2nd Transport Flotilla"
	id = { type = 13016 id = 223 }
	location = 502 #Southampton
	division = { id = { type = 13016 id = 224 } name = "2nd Transport Flotilla (A)" type = transport model = 1 }
	division = { id = { type = 13016 id = 225 } name = "2nd Transport Flotilla (B)" type = transport model = 1 }
	}



navalunit = {
	name = "11th Destroyer Flotilla"
	id = { type = 13016 id = 226 }
	location = 501 #Plymouth
	division = { id = { type = 13016 id = 227 } name = "11th Destroyer Flotilla (A)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 228 } name = "11th Destroyer Flotilla (B)" type = destroyer model = 1 }
	}

navalunit = {
	name = "15th Destroyer Flotilla (A)"
	id = { type = 13016 id = 229 }
	location = 487 #Actually based at Rosyth, but that is located in the same province as Edinburgh.
	division = { id = { type = 13016 id = 230 } name = "15th Destroyer Flotilla (A)" type = destroyer model = 4 }
	}

navalunit = {
	name = "15th Destroyer Flotilla (B)"
	id = { type = 13016 id = 231 }
	location = 491 #Actually based at Milford Haven, but that is located in the same province as Cardiff.
	division = { id = { type = 13016 id = 232 } name = "15th Destroyer Flotilla (B)" type = destroyer model = 4 }
	}

navalunit = {
	name = "16th Destroyer Flotilla"
	id = { type = 13016 id = 233 }
	location = 502 #Southampton
	division = { id = { type = 13016 id = 234 } name = "16th Destroyer Flotilla" type = destroyer model = 1 }
	}

navalunit = {
	name = "13th Destroyer Flotilla"
	id = { type = 13016 id = 235 }
	location = 503 #Portsmouth
	division = { id = { type = 13016 id = 236 } name = "13th Destroyer Flotilla (A)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 237 } name = "13th Destroyer Flotilla (B)" type = destroyer model = 1 }
	}


navalunit = {
	name = "Mediterranean Fleet"
	id = { type = 13016 id = 238 }
	location = 1099 #Alexandria
	leader = 1442 #W. Fisher
	division = { id = { type = 13016 id = 239 } name = "HMS Queen Elizabeth" type = battleship model = 3 maxspeed = 25 }
	division = { id = { type = 13016 id = 240 } name = "HMS Barham" type = battleship model = 3 maxspeed = 25 }
	division = { id = { type = 13016 id = 241 } name = "HMS Valiant" type = battleship model = 3 maxspeed = 25 }
	division = { id = { type = 13016 id = 243 } name = "HMS Revenge" type = battleship model = 3 }
	division = { id = { type = 13016 id = 245 } name = "HMS Courageous" type = carrier model = 6 }
	airunit = { id = { type = 13016 id = 1002 } name = "HMS Courageous Air Wing (TB)"
		division = { id = { type = 13016 id = 1003 } name = "Courageous Air Wing (TB)" strength = 100 type = torpedo_plane model = 0 }
		}
	division = { id = { type = 13016 id = 246 } name = "HMS Glorious" type =  carrier model = 6 }
	division = { id = { type = 13016 id = 247 } name = "HMS Devonshire" type = cruiser model = 5 }
	division = { id = { type = 13016 id = 248 } name = "HMS London" type = cruiser model = 5 } 
	division = { id = { type = 13016 id = 249 } name = "HMS Shropshire" type = 	cruiser model = 5 }
	division = { id = { type = 13016 id = 250 } name = "HMS Sussex" type = cruiser  model = 5 } 
	division = { id = { type = 13016 id = 251 } name = "HMS Berwick" type = cruiser model = 5 }
	division = { id = { type = 13016 id = 253 } name = "HMS York" type = cruiser model = 5 seaattack = 6 } 
	division = { id = { type = 13016 id = 254 } name = "HMS Coventry" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 255 } name = "HMS Curlew" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 256 } name = "HMS Delhi" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 257 } name = "HMS Despatch" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 258 } name = "HMS Durban" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 259 } name = "HMS Arethusa" type = cruiser model = 4 }
	division = { id = { type = 13016 id = 260 } name = "1st Destroyer Flotilla (A)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 261 } name = "1st Destroyer Flotilla (B)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 262 } name = "2nd Destroyer Flotilla (A)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 263 } name = "2nd Destroyer Flotilla (B)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 264 } name = "3rd Destroyer Flotilla (A)" type = destroyer model = 4 }
	division = { id = { type = 13016 id = 265 } name = "3rd Destroyer Flotilla (B)" type = destroyer model = 4 }
	}


navalunit = {
	name = "1st Submarine Flotilla"
	id = { type = 13016 id = 266 }
	location = 1099 #Alexandria
	division = { id = { type = 13016 id = 267 } name = "1st Submarine Flotilla (A)" type = submarine model = 1 }
	division = { id = { type = 13016 id = 268 } name = "1st Submarine Flotilla (B)" type = submarine model = 0 }
	}


navalunit = {
	name = "America & West Indies Station"
	id = { type = 13016 id = 269 }
	location = 222 #Bermuda
	division = { id = { type = 13016 id = 270 } name = "HMS Dragon" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 271 } name = "HMS Ajax" type = cruiser model = 4 }
	division = { id = { type = 13016 id = 272 } name = "12th Destroyer Flotilla" type = destroyer model = 1 }
	}


navalunit = {
	name = "Africa Station"
	id = { type = 13016 id = 273 }
	location = 1042 #Freetown
	division = { id = { type = 13016 id = 274 } name = "HMS Carlisle" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 275 } name = "17th Destroyer Flotilla (A)" type = destroyer model = 1 }
	}


navalunit = {
	name = "East Indies Station"
	id = { type = 13016 id = 276 }
	location = 1480 #Trincomalee - Located in Colombo
	division = { id = { type = 13016 id = 277 } name = "HMS Norfolk" type = cruiser model = 5 } #Heavy Cruiser
	division = { id = { type = 13016 id = 279 } name = "HMS Emerald" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 280 } name = "HMS Enterprise" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 281 } name = "14th Destroyer Flotilla" type = destroyer model = 1 }
	}


navalunit = {
	name = "China Station"
	id = { type = 13016 id = 282 }
	location = 1717 #Hong Kong

	division = { id = { type = 13016 id = 283 } name = "HMS Eagle" type = carrier model = 0 }
	airunit = { id = { type = 13016 id = 1004 } name = "HMS Eagle Air Wing (TB)"
		division = { id = { type = 13016 id = 1005 } name = "HMS Eagle Royal Air Wing (TB)" strength = 100 type = torpedo_plane model = 0 }
		}
	division = { id = { type = 13016 id = 284 } name = "HMS Cornwall" type = cruiser model = 5 } #Heavy Cruiser
	division = { id = { type = 13016 id = 285 } name = "HMS Cumberland" type = cruiser model = 5 } #Heavy Cruiser
	division = { id = { type = 13016 id = 286 } name = "HMS Kent" type = cruiser model = 5 }  #Heavy Cruiser
	division = { id = { type = 13016 id = 287 } name = "HMS Suffolk" type = cruiser model = 5 } #Heavy Cruiser
	division = { id = { type = 13016 id = 288 } name = "HMS Capetown" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 289 } name = "7th Destroyer Flotilla (A)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 290 } name = "7th Destroyer Flotilla (B)" type = destroyer model = 1 }
	}


navalunit = {
	name = "4th Submarine Flotilla"
	id = { type = 13016 id = 291 }
	location = 1717 #Hong Kong
	division = { id = { type = 13016 id = 292 } name = "5th Submarine Flotilla (A)" type = submarine model = 1 }
	division = { id = { type = 13016 id = 293 } name = "5th Submarine Flotilla (B)" type = submarine model = 0 }
	}


navalunit = {
	name = "Reserve Fleet"
	id = { type = 13016 id = 294 }
	location = 502 #Southampton
	division = { id = { type = 13016 id = 296 } name = "HMS Hermes" type = carrier model = 0  }
	division = { id = { type = 13016 id = 297 } name = "HMS Effingham" type = cruiser model = 3 seaattack = 7 } 
	division = { id = { type = 13016 id = 298 } name = "HMS Frobisher" type = cruiser model = 3 seaattack = 7 }
	division = { id = { type = 13016 id = 299 } name = "HMS Dorsetshire" type = cruiser model = 5 } 
	division = { id = { type = 13016 id = 300 } name = "HMS Hawkins" type = cruiser model = 3 seaattack = 7 } 
	division = { id = { type = 13016 id = 301 } name = "HMS Caledon" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 302 } name = "HMS Calypso" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 303 } name = "HMS Caradoc" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 304 } name = "HMS Calcutta" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 305 } name = "HMS Colombo" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 306 } name = "HMS Cardiff" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 307 } name = "HMS Ceres" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 308 } name = "HMS Curacoa" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 309 } name = "HMS Danae" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 310 } name = "HMS Dauntless" type = cruiser model = 3 }
	division = { id = { type = 13016 id = 311 } name = "17th Destroyer Flotilla (B)" type = destroyer model = 1 }
	division = { id = { type = 13016 id = 312 } name = "18th Destroyer Flotilla (A)" type = destroyer model = 1 }
	}


development = { 
	id = { type = 13016 id = 242 } 
	name = "HMS Malaya" 
	type = battleship 
	model = 3 
	cost = 1
#	maxspeed = 25
	date = { day = 1 month = december year = 1936 }
}

development = { 
	id = { type = 13016 id = 295 } 
	name = "HMS Warspite" 
	type = battleship 
	model = 3
	cost = 1
#	maxspeed = 25
	date = { day = 1 month = march year = 1939 }
	}

development = { 
	id = { type = 13016 id = 244 } 
	name = "HMS Repulse" 
	type = battleship 
	model = 4 
	cost = 1
	date = { day = 1 month = may year = 1936 }
	}


development = {
	id = { type = 13016 id = 3020 }
	name = "HMS Exeter"
	type = cruiser
	model = 5
	cost = 2
#	seaattack = 6
	date = { day = 1 month = july year = 1937 }
	}

development = {
	id = { type = 13016 id = 3021 }
	name = "HMS Aurora"
	type = cruiser
	model = 4
	cost = 2
	date = { day = 12 month = november year = 1937 }
	}

development = {
	id = { type = 13016 id = 3022 }
	name = "HMS Penelope"
	type = cruiser
	model = 4
	cost = 2
	date = { day = 13 month = november year = 1936 }
	}

development = {
	id = { type = 13016 id = 3023 }
	name = "HMS Birmingham"
	type = cruiser
	model = 4
	cost = 2
	date = { day = 18 month = november year = 1937 }
	}

development = {
	id = { type = 13016 id = 3024 }
	name = "HMS Glasgow"
	type = cruiser
	model = 4
	cost = 2
	date = { day = 9 month = september year = 1937 }
	}

development = {
	id = { type = 13016 id = 3025 }
	name = "HMS Newcastle"
	type = cruiser
	model = 4
	cost = 2
	date = { day = 5 month = march year = 1937 }
	}

development = {
	id = { type = 13016 id = 3026 }
	name = "HMS Sheffield"
	type = cruiser
	model = 4
	cost = 2
	date = { day = 25 month = august year = 1937 }
	}

development = {
	id = { type = 13016 id = 3027 }
	name = "HMS Southampton"
	type = cruiser
	model = 4
	cost = 2
	date = { day = 6 month = march year = 1937 }
	}
development = {
	name = "18th Destroyer Flotilla (B)"
	type = destroyer
	model = 4
	cost = 2
	id = { type = 13016 id = 3008 }
	date = { year = 1936 month = june }
	}

#####################################

deactivate = { 11508 13504 11512 11507 11511 11513 11514 11515 11516 11517 }

    modifiers = { 
        infantry = { 
            mountain_attack = -40 
            hill_attack = -10 
            forest_attack = -10 
            jungle_attack = 5 
            swamp_attack = -15 
            urban_attack = -15 
            river_attack = -20 
            shore_attack = -15 
            paradrop_attack = -15 
            fort_attack = -15 
            blizzard_defense = -15 
            snow_defense = -15 
            frozen_defense = -15 
            rain_defense = -15 
            storm_defense = -15 
            muddy_defense = -15 
            night_defense = -15 
            desert_defense = -15 
            mountain_defense = 15 
            hill_defense = 5 
            forest_defense = 10 
            jungle_defense = 50 
            swamp_defense = 10 
            urban_defense = 10 
            blizzard_move = -70 
            snow_move = -40 
            frozen_move = -25 
            rain_move = -10 
            storm_move = -30 
            muddy_move = -40 
            night_move = -15 
            desert_move = -15 
            mountain_move = -15 
            hill_move = -15 
            forest_move = -15 
            jungle_move = -15 
            swamp_move = -15 
            urban_move = -15 
            } 
        cavalry = { 
            mountain_attack = -40 
            hill_attack = -10 
            forest_attack = -10 
            jungle_attack = -15 
            swamp_attack = -15 
            urban_attack = -15 
            river_attack = -25 
            shore_attack = -15 
            paradrop_attack = -15 
            fort_attack = -15 
            blizzard_defense = -15 
            snow_defense = -15 
            frozen_defense = -15 
            rain_defense = -15 
            storm_defense = -15 
            muddy_defense = -15 
            night_defense = -15 
            desert_defense = -15 
            mountain_defense = 15 
            hill_defense = 5 
            forest_defense = 10 
            jungle_defense = 30 
            swamp_defense = 10 
            urban_defense = 10 
            blizzard_move = -70 
            snow_move = -40 
            frozen_move = -25 
            rain_move = -10 
            storm_move = -30 
            muddy_move = -40 
            night_move = -15 
            desert_move = -15 
            mountain_move = -15 
            hill_move = -15 
            forest_move = -15 
            jungle_move = -15 
            swamp_move = -15 
            urban_move = -15 
            } 
        motorized = { 
            mountain_attack = -80 
            hill_attack = -20 
            forest_attack = -10 
            jungle_attack = -60 
            swamp_attack = -50 
            urban_attack = -50 
            river_attack = -40 
            shore_attack = -30 
            paradrop_attack = -30 
            fort_attack = -30 
            blizzard_defense = -30 
            snow_defense = -30 
            frozen_defense = -30 
            rain_defense = -30 
            storm_defense = -30 
            muddy_defense = -30 
            night_defense = -30 
            desert_defense = -30 
            mountain_defense = 15 
            hill_defense = 5 
            forest_defense = 10 
            jungle_defense = 50 
            swamp_defense = 10 
            urban_defense = 10 
            blizzard_move = -50 
            snow_move = -40 
            frozen_move = -25 
            rain_move = -25 
            storm_move = -50 
            muddy_move = -90 
            night_move = -15 
            desert_move = -15 
            mountain_move = -50 
            hill_move = -40 
            forest_move = -50 
            jungle_move = -80 
            swamp_move = -80 
            urban_move = -70 
            } 
        mechanized = { 
            mountain_attack = -80 
            hill_attack = -20 
            forest_attack = -10 
            jungle_attack = -60 
            swamp_attack = -50 
            urban_attack = -50 
            river_attack = -40 
            shore_attack = -30 
            paradrop_attack = -30 
            fort_attack = -20 
            blizzard_defense = -30 
            snow_defense = -30 
            frozen_defense = -30 
            rain_defense = -30 
            storm_defense = -30 
            muddy_defense = -30 
            night_defense = -30 
            desert_defense = -30 
            mountain_defense = 15 
            hill_defense = 5 
            forest_defense = 10 
            jungle_defense = 30 
            swamp_defense = 10 
            urban_defense = 10 
            blizzard_move = -40 
            snow_move = -35 
            frozen_move = -25 
            rain_move = -25 
            storm_move = -50 
            muddy_move = -75 
            night_move = -15 
            desert_move = -15 
            mountain_move = -50 
            hill_move = -40 
            forest_move = -50 
            jungle_move = -80 
            swamp_move = -80 
            urban_move = -70 
            } 
        panzer = { 
            mountain_attack = -80 
            hill_attack = -20 
            forest_attack = -10 
            jungle_attack = -60 
            swamp_attack = -50 
            urban_attack = -50 
            river_attack = -40 
            shore_attack = -30 
            paradrop_attack = -30 
            fort_attack = -20 
            blizzard_defense = -30 
            snow_defense = -30 
            frozen_defense = -30 
            rain_defense = -30 
            storm_defense = -30 
            muddy_defense = -30 
            night_defense = -30 
            desert_defense = -30 
            mountain_defense = 15 
            hill_defense = 5 
            forest_defense = 10 
            jungle_defense = 30 
            swamp_defense = 10 
            urban_defense = 10 
            blizzard_move = -40 
            snow_move = -35 
            frozen_move = -25 
            rain_move = -25 
            storm_move = -50 
            muddy_move = -75 
            night_move = -15 
            desert_move = -15 
            mountain_move = -50 
            hill_move = -40 
            forest_move = -50 
            jungle_move = -80 
            swamp_move = -80 
            urban_move = -70 
            } 
        paratrooper = { 
            mountain_attack = -40 
            hill_attack = -10 
            forest_attack = -10 
            jungle_attack = 5 
            swamp_attack = -15 
            urban_attack = -15 
            river_attack = -20 
            shore_attack = -15 
            paradrop_attack = -15 
            fort_attack = -15 
            blizzard_defense = -15 
            snow_defense = -15 
            frozen_defense = -15 
            rain_defense = -15 
            storm_defense = -15 
            muddy_defense = -15 
            night_defense = -15 
            desert_defense = -15 
            mountain_defense = 15 
            hill_defense = 5 
            forest_defense = 10 
            jungle_defense = 50 
            swamp_defense = 10 
            urban_defense = 10 
            blizzard_move = -70 
            snow_move = -40 
            frozen_move = -25 
            rain_move = -10 
            storm_move = -30 
            muddy_move = -40 
            night_move = -15 
            desert_move = -15 
            mountain_move = -15 
            hill_move = -15 
            forest_move = -15 
            jungle_move = -15 
            swamp_move = -15 
            urban_move = -15 
            } 
        marine = { 
            mountain_attack = -40 
            hill_attack = -10 
            forest_attack = -10 
            jungle_attack = 15 
            swamp_attack = -5 
            urban_attack = -5 
            river_attack = -5 
            shore_attack = -5 
            paradrop_attack = -5 
            fort_attack = -5 
            blizzard_defense = -5 
            snow_defense = -5 
            frozen_defense = -5 
            rain_defense = -5 
            storm_defense = -5 
            muddy_defense = -5 
            night_defense = -5 
            desert_defense = -5 
            mountain_defense = 15 
            hill_defense = 5 
            forest_defense = 10 
            jungle_defense = 70 
            swamp_defense = 20 
            urban_defense = 20 
            blizzard_move = -70 
            snow_move = -40 
            frozen_move = -25 
            rain_move = -10 
            storm_move = -30 
            muddy_move = -40 
            night_move = -15 
            desert_move = -15 
            mountain_move = -15 
            hill_move = -15 
            forest_move = -15 
            jungle_move = -15 
            swamp_move = -15 
            urban_move = -15 
            } 
        bergsjaeger = { 
            jungle_attack = 5 
            swamp_attack = -15 
            urban_attack = -15 
            river_attack = -20 
            shore_attack = -15 
            paradrop_attack = -15 
            fort_attack = -15 
            blizzard_defense = -15 
            snow_defense = -15 
            frozen_defense = -15 
            rain_defense = -15 
            storm_defense = -15 
            muddy_defense = -15 
            night_defense = -15 
            desert_defense = -15 
            mountain_defense = 50 
            hill_defense = 25 
            forest_defense = 10 
            jungle_defense = 50 
            swamp_defense = 10 
            urban_defense = 10 
            blizzard_move = -70 
            snow_move = -40 
            frozen_move = -25 
            rain_move = -10 
            storm_move = -30 
            muddy_move = -40 
            night_move = -15 
            desert_move = -15 
            mountain_move = -15 
            hill_move = -15 
            forest_move = -15 
            jungle_move = -15 
            swamp_move = -15 
            urban_move = -15 
            } 
        militia = { 
            mountain_attack = -40 
            hill_attack = -10 
            forest_attack = -10 
            jungle_attack = -15 
            swamp_attack = -15 
            urban_attack = -15 
            river_attack = -20 
            shore_attack = -15 
            paradrop_attack = -15 
            fort_attack = -15 
            blizzard_defense = -15 
            snow_defense = -15 
            frozen_defense = -15 
            rain_defense = -15 
            storm_defense = -15 
            muddy_defense = -15 
            night_defense = -15 
            desert_defense = -15 
            mountain_defense = 15 
            hill_defense = 5 
            forest_defense = 10 
            jungle_defense = 30 
            swamp_defense = 10 
            urban_defense = 10 
            blizzard_move = -70 
            snow_move = -25 
            frozen_move = -25 
            rain_move = -10 
            storm_move = -25 
            muddy_move = -25 
            night_move = -15 
            desert_move = -15 
            mountain_move = -15 
            hill_move = -15 
            forest_move = -15 
            jungle_move = -15 
            swamp_move = -15 
            urban_move = -15 
            } 
        fighter = { 
            snow_attack = -30 
            frozen_attack = 0 
            rain_attack = -30 
            storm_attack = -30 
            muddy_attack = 1 
            night_attack = -30 
            desert_attack = 1 
            mountain_attack = 1 
            hill_attack = 1 
            forest_attack = 1 
            jungle_attack = 1 
            swamp_attack = 1 
            urban_attack = 1 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 50 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = 1 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = 1 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            } 
        strategic_bomber = { 
            snow_attack = -10 
            frozen_attack = 1 
            rain_attack = -10 
            storm_attack = 1 
            muddy_attack = 1 
            night_attack = -10 
            desert_attack = 1 
            mountain_attack = 1 
            hill_attack = 1 
            forest_attack = 1 
            jungle_attack = 1 
            swamp_attack = 1 
            urban_attack = 20 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 50 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = 1 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = 1 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
} 
        tactical_bomber = { 
            snow_attack = -30 
            frozen_attack = 1 
            rain_attack = -30 
            storm_attack = -50 
            muddy_attack = 1 
            night_attack = -80 
            desert_attack = 1 
            mountain_attack = -20 
            hill_attack = 1 
            forest_attack = -20 
            jungle_attack = -40 
            swamp_attack = 1 
            urban_attack = -20 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 90 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = 1 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = 1 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            } 
        dive_bomber = { 
            snow_attack = -30 
            frozen_attack = 1 
            rain_attack = -30 
            storm_attack = -50 
            muddy_attack = 1 
            night_attack = -80 
            desert_attack = 1 
            mountain_attack = -20 
            hill_attack = 1 
            forest_attack = -20 
            jungle_attack = -40 
            swamp_attack = 1 
            urban_attack = -20 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 90 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = 1 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = 1 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            } 
        naval_bomber = { 
            snow_attack = -30 
            frozen_attack = 1 
            rain_attack = -30 
            storm_attack = -50 
            muddy_attack = 1 
            night_attack = -80 
            desert_attack = 1 
            mountain_attack = -20 
            hill_attack = 1 
            forest_attack = -20 
            jungle_attack = -40 
            swamp_attack = 1 
            urban_attack = -20 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 90 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = 1 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = 1 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            } 
        torpedo_plane = { 
            snow_attack = -30 
            frozen_attack = 1 
            rain_attack = -30 
            storm_attack = -50 
            muddy_attack = 1 
            night_attack = -80 
            desert_attack = 1 
            mountain_attack = -20 
            hill_attack = 1 
            forest_attack = -20 
            jungle_attack = -40 
            swamp_attack = 1 
            urban_attack = -20 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 90 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = 1 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = 1 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            jungle_move = 1 
            swamp_move = 1 
            urban_move = 1 
            } 
        transport_plane = { 
            night_defense = 50 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = 1 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = 1 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            jungle_move = 1 
            swamp_move = 1 
            urban_move = 1 
            } 
        flying_bomb = { } 
        flying_rocket = { } 
        battleship = { 
            night_attack = 1 
            desert_attack = 1 
            mountain_attack = 1 
            hill_attack = 1 
            forest_attack = 1 
            jungle_attack = 1 
            swamp_attack = 1 
            urban_attack = 1 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 1 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = -20 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = -20 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            jungle_move = 1 
            swamp_move = 1 
            urban_move = 1
} 
        cruiser = { 
            night_attack = 1 
            desert_attack = 1 
            mountain_attack = 1 
            hill_attack = 1 
            forest_attack = 1 
            jungle_attack = 1 
            swamp_attack = 1 
            urban_attack = 1 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 1 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = -20 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = -20 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            jungle_move = 1 
            swamp_move = 1 
            urban_move = 1
} 
        destroyer = { 
            night_attack = 30 
            desert_attack = 1 
            mountain_attack = 1 
            hill_attack = 1 
            forest_attack = 1 
            jungle_attack = 1 
            swamp_attack = 1 
            urban_attack = 1 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 1 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = -20 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = -20 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            jungle_move = 1 
            swamp_move = 1 
            urban_move = 1
            } 
        carrier = { 
            night_attack = 1 
            desert_attack = 1 
            mountain_attack = 1 
            hill_attack = 1 
            forest_attack = 1 
            jungle_attack = 1 
            swamp_attack = 1 
            urban_attack = 1 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 1 
            snow_defense = 1 
            frozen_defense = 1 
            rain_defense = 1 
            storm_defense = 1 
            muddy_defense = 1 
            night_defense = 1 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = -20 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = -20 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            jungle_move = 1 
            swamp_move = 1 
            urban_move = 1
} 
        submarine = { 
            night_attack = 50 
            desert_attack = 1 
            mountain_attack = 1 
            hill_attack = 1 
            forest_attack = 1 
            jungle_attack = 1 
            swamp_attack = 1 
            urban_attack = 1 
            river_attack = 1 
            shore_attack = 1 
            paradrop_attack = 1 
            fort_attack = 1 
            blizzard_defense = 30 
            snow_defense = 20 
            frozen_defense = 1 
            rain_defense = 20 
            storm_defense = 20 
            muddy_defense = 1 
            night_defense = 50 
            desert_defense = 1 
            mountain_defense = 1 
            hill_defense = 1 
            forest_defense = 1 
            jungle_defense = 1 
            swamp_defense = 1 
            urban_defense = 1 
            blizzard_move = 1 
            snow_move = 1 
            frozen_move = 1 
            rain_move = 1 
            storm_move = -20 
            muddy_move = 1 
            night_move = 1 
            desert_move = 1 
            mountain_move = 1 
            hill_move = 1 
            forest_move = 1 
            jungle_move = 1 
            swamp_move = 1 
            urban_move = 1
            } 
        transport = { } 
        }




} 




